/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.opengl;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import frc.emul.config.data.CfgItemTexture;
import frc.emul.tools.data.TexLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import javax.media.opengl.GL;

public class JoglTexture {
    private CfgItemTexture source;
    private boolean obsolete;
    private int texture;
    private int width;
    private int height;
    private int format;
    private int bpp;
    private int minFilter;
    private int maxFilter;
    private boolean flipped;

    public JoglTexture() {
        this(6408, 4);
    }

    public JoglTexture(int n, int n2) {
        this.setup(n, n2, 9729, 9729);
    }

    public JoglTexture(CfgItemTexture cfgItemTexture) {
        this.setSource(cfgItemTexture);
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSize(int n, int n2) {
        if (n != this.width || n2 != this.height || this.source != null) {
            this.width = n;
            this.height = n2;
            this.source = null;
            this.obsolete = true;
        }
    }

    public void setSource(CfgItemTexture cfgItemTexture) {
        this.source = cfgItemTexture;
        this.obsolete = true;
    }

    public void setup(int n, int n2, int n3, int n4) {
        if (this.source != null) {
            throw new IllegalStateException("Cannot change this parameter for a source texture");
        }
        this.format = n;
        this.bpp = n2;
        this.minFilter = n3;
        this.maxFilter = n4;
        this.obsolete = true;
    }

    public void bind(GL gL, int n) {
        gL.glActiveTexture(33984 + n);
        this.bind(gL);
    }

    public void bind(GL gL) {
        gL.glBindTexture(3553, this.getTexture(gL));
    }

    public void unbind(GL gL) {
        gL.glBindTexture(3553, 0);
    }

    public void release(GL gL) {
        if (this.texture != 0) {
            gL.glDeleteTextures(1, new int[]{this.texture}, 0);
            this.texture = 0;
            this.obsolete = true;
        }
    }

    public void update(GL gL) {
        if (this.obsolete) {
            this.release(gL);
            this.texture = this.source == null ? this.allocate(gL) : this.load(gL);
            this.obsolete = false;
        }
    }

    int getTexture(GL gL) {
        this.update(gL);
        return this.texture;
    }

    private int allocate(GL gL) {
        this.flipped = false;
        int n = this.width * this.height * this.bpp;
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        gL.glBindTexture(3553, nArray[0]);
        gL.glTexImage2D(3553, 0, this.format, this.width, this.height, 0, this.format, 5121, (Buffer)BufferUtil.newByteBuffer((int)n));
        gL.glTexParameteri(3553, 10241, this.minFilter);
        gL.glTexParameteri(3553, 10240, this.maxFilter);
        return nArray[0];
    }

    private int load(GL gL) {
        this.flipped = false;
        if (this.source.hasTexture()) {
            String string = this.source.path;
            InputStream inputStream = null;
            try {
                inputStream = TexLoader.getResourceStream(string, this.source.kind);
                if (inputStream != null) {
                    Texture texture = JoglTexture.loadTexture(gL, inputStream, this.source);
                    this.flipped = texture.getMustFlipVertically();
                    this.width = texture.getImageWidth();
                    this.height = texture.getImageHeight();
                    return texture.getTextureObject();
                }
                System.out.println("File does not exist or cannot be read : " + string);
            }
            catch (Exception exception) {
                System.out.println("Error while loading texture : " + string);
                exception.printStackTrace(System.out);
            }
        }
        return 0;
    }

    private static final Texture loadTexture(GL gL, InputStream inputStream, CfgItemTexture cfgItemTexture) throws IOException {
        Texture texture;
        String string = cfgItemTexture.path;
        System.out.println("Loading " + cfgItemTexture.description + " texture [" + string.replace('\\', '/') + "]");
        System.out.flush();
        try {
            texture = TextureIO.newTexture((InputStream)inputStream, (boolean)cfgItemTexture.mipmap, (String)FileUtil.getFileSuffix((String)string));
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        return texture;
    }
}

